

// multiple script protection
if (typeof(COMSCORE) != "undefined" && typeof(COMSCORE.AdRecruit) != "undefined") {
	
	var logSettings = COMSCORE.AdRecruit.Broker.config.logSettings;
	var masterSettings = COMSCORE.AdRecruit.Broker.config.masterSettings;
	// log ad exposure because we have another script already running
	
	var ar = COMSCORE.AdRecruit;
	COMSCORE.AdRecruit.Broker.logExposure();
	/*
	if (ar.Broker.arc != ar.Broker.config.masterSettings.controlAdArc) {
		ar.Utils.fireBeacon(ar.Broker.executingPath + logSettings.exposureBeaconUrl + 
		                    "?pid=" + masterSettings.projectId +
							"&prad=" + ar.Broker.prad + 
							"&arc=" + ar.Broker.arc +
							"&grp=1" +
							"&redirectUrl=" + logSettings.panelistLogUrl, true);
	}
	else {
		ar.Utils.fireBeacon(logSettings.panelistLogUrl + 
							"?pid=" + masterSettings.projectId +
							"&prad=" + ar.Broker.prad + 
							"&arc=" + ar.Broker.arc +
							"&grp=0", true);
	}
	*/
}
else {

if (typeof(COMSCORE) == "undefined") {
	var COMSCORE = {};
}
COMSCORE.AdRecruit = {
	builderUrl: "ar_builder.js",		// full url to invitation builder
	wpopUrl: "ar_wpop.js",
	CONSTANTS: {
		COOKIE_TYPE: { ALREADY_ASKED: 1 },
		SCRIPT_PLACEMENT: {
			NO_IFRAME: 1,
			IFRAME_SAME_DOMAIN: 2,
			IFRAME_DIFF_DOMAIN: 3
		},
		
		COOKIE_VAL_DELIMITER: '>',
		
		METHODOLOGY: {
			STANDARD: 1,
			DD: 2,
			WPOP: 3	
		}
	}	
};




COMSCORE.AdRecruit.Utils = (function() {
	return {
		
		
		location: document.location.href,
		
		cookie: {
			get: function(key) {
				var value = document.cookie.match("(?:^|;)\\s*" + key + "=([^;]*)");
				return value ? unescape(value[1]) : false;
			}
		},
		
		fireBeacon: function (url, isFresh, options) {
			var that = this;
			setTimeout(function() {
				if (isFresh) {
					url += (/\?/.test(url) ? '&' : '?') + (new Date()).getTime();
				}
				
				var i = new Image();
				i.src = url;
				if (options) {
					if (options.width) {
						i.width = options.width;
					}
					if (options.height) {
						i.height = options.height;
					}
					if (options.border) {
						i.border = options.border;
					}
					if (options.alt) {
						i.alt = options.alt;
					}
				}
				
			}, 1);
		},
		
		loadScript: function(url, loadFresh, id) {
			if (loadFresh) {
				url = this.appendQueryParams(url, (new Date()).getTime());
			}
			
			
			
			//document.write("<script src=\"" + url + "\"></script>");
			var s = document.createElement("script");
			s.src = url;
			document.body.appendChild(s);
		},
		
		appendQueryParams: function(url, params) {
			if (url == null || params == null) {
				
			}
						
			if (!/\?/.test(url)) {
				url += '?';
			}
		
			url += '&' + params.toString().replace('?', '');
						
			return url;			
		},
		
		getRandom: function(num) {
			var rand = Math.random();
			// if passed arg, return number between 0 and num, else return float
			if (!num) {
				return rand;
			}
			else {
				return Math.floor(rand*( num + 1 ));
			}
		},
		
		checkPlacement: function() {
			try {
				if (parent.document.location.href == document.location.href) {
					
					return COMSCORE.AdRecruit.CONSTANTS.SCRIPT_PLACEMENT.NO_IFRAME;
				}
				else {
					
					if (COMSCORE.AdRecruit.Broker.getPradSettings().methodology == 4)
					{
						return COMSCORE.AdRecruit.CONSTANTS.SCRIPT_PLACEMENT.NO_IFRAME;
					}
					return COMSCORE.AdRecruit.CONSTANTS.SCRIPT_PLACEMENT.IFRAME_SAME_DOMAIN;
				}
			}
			catch(e) {
				if (COMSCORE.AdRecruit.Broker.getPradSettings().methodology == 4)
				{
					
					return COMSCORE.AdRecruit.CONSTANTS.SCRIPT_PLACEMENT.NO_IFRAME;
				}
				else
				{
					
					return COMSCORE.AdRecruit.CONSTANTS.SCRIPT_PLACEMENT.IFRAME_DIFF_DOMAIN;
				}
			}
		}
	};
}());


COMSCORE.AdRecruit.Broker = (function() {
	var _ar = COMSCORE.AdRecruit;
	var _utils = _ar.Utils;
			
	return {
		version: "1.2",
		
		
		
		init: function() {
			this.executingPath = this.getExecutingPath();
			//prime random
			Math.random();
			
			
			
			this.getPradAndArc();
			this.logExposure();
		},
				
		start: function() {
			if (this.isBrowserValid()) {
				_ar.OnReady.listen();
				//get script args, find pradSettings
				this.init();
			
				this.waitForDOM();	
			}
			
		},
		
		waitForDOM: function() {
			this.counter = 0;
			this.waitInterval = setInterval( 
				function() {
					var url = _ar.Broker.executingPath + _ar.Broker.config.cookieSettings.hostedCookieReadUrl + 
									"?n=" + _ar.Broker.config.cookieSettings.exposureCookieName;
						
					if (_ar.OnReady.done) {
						clearInterval(COMSCORE.AdRecruit.Broker.waitInterval);
						
						
						_utils.loadScript(url + "&func=COMSCORE.AdRecruit.Broker.canRecruit", true, false);
					}
					else if (COMSCORE.AdRecruit.Broker.counter++ > 5 ) {
						clearInterval(COMSCORE.AdRecruit.Broker.waitInterval);
						
						
					}
				}, 1000);
		},
		
		canRecruit: function(c) {
			_ar.currentPradSetting = this.getPradSettings();
			_ar.currentPradSetting = this.overridePradSettings(_ar.currentPradSetting, this.getArcSettings());
			
			this.Site = this.getSiteCodeFromARC();
			
			if ((c && c != "") && this.arc == _ar.Broker.config.masterSettings.controlAdArc) {
				
				return;
			}
			
			if (this.isExcludeUrl(_utils.location) || this.isExcludePrad() || !this.isIncludeUrl(_utils.location)) {				
				
				return;
			}
			
			if (_ar.currentPradSetting.delay) {
					
			}
			else {
				_ar.currentPradSetting.delay = 0;
			}
			setTimeout(function() {
						if (_ar.Broker.config.cookieSettings.useHostedCookie) {
							var url = _ar.Broker.executingPath + _ar.Broker.config.cookieSettings.hostedCookieReadUrl + 
									"?n=" + _ar.Broker.config.cookieSettings.alreadyAskedCookieName;
							
							_utils.loadScript(url + "&func=COMSCORE.AdRecruit.Broker.checkAlreadyAsked", true, false);
						}	
						else {
							var c = _utils.cookie.get(_ar.Broker.config.cookieSettings.alreadyAskedCookieName);
							COMSCORE.AdRecruit.Broker.checkAlreadyAsked(c);			
						}
					},
			_ar.currentPradSetting.delay);
		},
				
		checkAlreadyAsked: function(c) {
			if (c && c != "") {
				
				
				var value = unescape(c);
				if (/2>/.test(value)) {
					
					
					var arr = value.split(COMSCORE.AdRecruit.CONSTANTS.COOKIE_VAL_DELIMITER);
					var now = (new Date()).getTime();
					if ((now - arr[2]) > 60000) {
						
						return;
					}
					
					COMSCORE.AdRecruit.DDKeepAlive.start();
				}
				
				return;
			}
			else {		
				//check interaction cookie
				var interactUrl = this.executingPath + this.config.cookieSettings.hostedCookieReadUrl + "?n=" + 
							   this.config.cookieSettings.interactionCookieName;
				_utils.loadScript(interactUrl + "&func=COMSCORE.AdRecruit.Broker.recruit", true, false);
			}		
		},
		
		recruit: function(c) {
			//fix this !!1
			if (c && c != "") {
				
				_ar.currentPradSetting.recruitFrequency = _ar.currentPradSetting.interactionFrequency;
			}			
			
			this.config.placement = _utils.checkPlacement();
			
			if (_ar.currentPradSetting.recruitFrequency  > _utils.getRandom()) {
				
				if (_ar.currentPradSetting.inv == "yahoo") { 
					_utils.fireBeacon("https://pclick.yahoo.com/p/s=2023700693/lng=us/rand="+Math.random(), true, {alt: 'Yahoo Image', width: 1, height: 1, border:0}); 
				} 
				
				if (this.Site != false) {
					this.scriptArgs += "&site=" + this.Site;
				}
				this.scriptArgs += "&location=" + encodeURIComponent(_utils.location) +
						           "&referrer=" + encodeURIComponent(document.referrer);
				var _sp = _ar.CONSTANTS.SCRIPT_PLACEMENT;
				
				if (_ar.currentPradSetting.methodology == 4) { 
					var ar_winWidth, ar_winHeight;
					
					if (typeof(window.innerWidth) == 'number') {
    			    ar_winHeight = window.innerHeight;
    			}
    			else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
    			    ar_winHeight = document.documentElement.clientHeight;
    			}
    			else if (document.body && (document.body.clientWidth || document.body.clientHeight)) {
    			    ar_winHeight = document.body.clientHeight;
    			}
					
					if (typeof(window.innerWidth) == 'number') {
        		ar_winWidth = window.innerWidth;
    			}
    			else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
    			    ar_winWidth = document.documentElement.clientWidth;
    			}
    			else if (document.body && (document.body.clientWidth || document.body.clientHeight)) {
    			    ar_winWidth = document.body.clientWidth;
    			}
    			
    			_ar.currentPradSetting.methodology = 1; 
    			
    			if (ar_winWidth == 300 && ar_winHeight == 250) {
    				_ar.currentPradSetting.inv = 'inv_300x250';
    			}
    			else if (ar_winWidth == 728 && ar_winHeight == 90) {
    				_ar.currentPradSetting.inv = 'inv_728x90';
    			}
    			else if (ar_winWidth == 160 && ar_winHeight == 600) {
    				_ar.currentPradSetting.inv = 'inv_160x600';
    			}
    			else {
    				_ar.currentPradSetting.methodology = 4;
    			} 

					
				}
				
				if ((this.config.placement == _sp.NO_IFRAME || this.config.placement == _sp.IFRAME_SAME_DOMAIN) && 
				     (_ar.currentPradSetting.methodology == _ar.CONSTANTS.METHODOLOGY.STANDARD ||
					  _ar.currentPradSetting.methodology == _ar.CONSTANTS.METHODOLOGY.DD)) {
					
					_utils.loadScript(this.executingPath + _ar.builderUrl, true);
				
				}
				else if (this.config.placement == _sp.IFRAME_DIFF_DOMAIN || 
						 _ar.currentPradSetting.methodology == _ar.CONSTANTS.METHODOLOGY.WPOP){
					if (_ar.currentPradSetting.isWPopAllowed) {
						
						var iframeUrl = this.executingPath + "iframe.htm?" + this.scriptArgs + 
						                "&frequency=" + _ar.currentPradSetting.recruitFrequency + _ar.currentPradSetting.acceptParamsRaw +
										"&wpopAcceptUrl=" + encodeURIComponent(_ar.currentPradSetting.acceptUrl) +
										"&inviteDuration=" + _ar.currentPradSetting.inviteDuration +
										"&acceptWindowFeatures=" + encodeURIComponent(_ar.currentPradSetting.acceptWindowFeatures) +
										"&" + (new Date()).getTime();
						var c = document.createElement("iframe");
						c.width = "0px";
						c.height = "0px";
						c.style.display ="none";
						c.src = iframeUrl;
						document.body.appendChild(c);
						//_utils.loadScript(url, true);
					}
					
				}
				
			}
				
		},
		
		isIncludeUrl: function(url) {
			var include = this.config.masterSettings.includeUrl;
			if (!include || include == "" || new RegExp(include, "i").test(url)) {
				
				return true;
			}
			return false;
		},
		
		isBrowserValid: function() {
			var ie = 'Microsoft Internet Explorer', mozilla = 'Netscape', opera = 'Opera';
			var browserName = navigator.appName, browserVersion = parseInt(navigator.appVersion, 10);
			var isInternetExplorer = isMozilla = false;
			
			if (browserName == ie) { if (browserVersion > 3) {isInternetExplorer = true; } }
			if (browserName == mozilla || browserName == opera) { if (browserVersion > 4) { isMozilla = true; } }
			
			return isInternetExplorer || isMozilla;
		},
		
		getExecutingPath: function() {
			var tags = document.getElementsByTagName("script");
			for (var i = tags.length - 1; i >= 0; i--) {
				var c = tags[i].src;
				
				this.scriptUrl = c;
				
				if (c.indexOf(".voicefive.com") != -1 || c.indexOf("/ar.js") != -1)	{	
					this.scriptArgs = this.getScriptArgs();
					return c.replace(/(.*)(\/.*)$/, '$1/');
				}
			}
		},
		
		getScriptArgs: function() {
			// grab script's querystring
			if (/\?(.*)/.test(this.scriptUrl)) {
				return RegExp.$1;
			}
			return null;
		},
		
		getPradAndArc: function() {
			var rPRAD = new RegExp(this.config.masterSettings.pradName + "=(\\w+)","i");
			if (rPRAD.test(this.scriptArgs)) {
				this.prad = RegExp.$1.toString();
			}
			
			var rARC = new RegExp(this.config.masterSettings.arcName + "=(\\w+)","i");
			if (rARC.test(this.scriptArgs)) {
				this.arc = RegExp.$1.toString();
			}
		
		},
		
		getPradSettings: function() {
			
			var len = this.config.pradSettings.arr.length;
			for (var i = 0; i < len; i++) {
				var len2 = this.config.pradSettings.arr[i].prad.length;
				for (var j = 0; j < len2; j++) {
					if (this.config.pradSettings.arr[i].prad[j] == this.prad) {
						
						return this.config.pradSettings.arr[i];	
					}
				}
			}
			
			return this.config.pradSettings.defaultPrad;
		},
		
		getArcSettings: function() {
			
			var len = this.config.arcSettings.arr.length;
			for (var i = 0; i < len; i++) {
				var len2 = this.config.arcSettings.arr[i].arc.length;
				for (var j = 0; j < len2; j++) {
					if (this.config.arcSettings.arr[i].arc[j] == this.arc) {
						
						return this.config.arcSettings.arr[i];	
					}
				}
			}
			
			return null;
		},
		
		overridePradSettings: function(pradSettings, arcSettings) {
			if (arcSettings != null) {
				
				for (var x in arcSettings) {
					pradSettings[x] = arcSettings[x];
				}
			}
			return pradSettings;
		},
		
		isExcludeUrl: function(url) {
			var gExcludeL = _ar.Broker.globalConfig.urlExcludeList;
			if (gExcludeL && gExcludeL != "" && new RegExp(gExcludeL, "i").test(url)) {
				return true;
			}
			
			var excludeL = this.config.masterSettings.excludeUrl;
			if (excludeL && excludeL != "" && new RegExp(excludeL, "i").test(url)) {
				return true;
			}
			return false;	
		},
		
		isExcludePrad: function() {
			var excludePrad = this.config.masterSettings.excludePrad;
			if (excludePrad && excludePrad != "" && new RegExp(excludePrad, "i").test(this.prad)) {
				return true;
			}
			return false;
		},
		
		getSiteCodeFromARC: function() {
			//arc table stuff
			if (this.config.arcSettings.trackCreative) {			
				if (!this.arc) {
					var r = new RegExp(this.config.masterSettings.arcName + "=(\\w+)","i");
					if (r.test(this.scriptArgs)) {
						this.arc = RegExp.$1;
					}
				}
				if (this.config.arcSettings.translateTable[this.arc]) {
					
					return this.config.arcSettings.translateTable[this.arc];
				}
				
				
				
				if (this.config.arcSettings.translateTable["defaultARC"]||
				    typeof(this.arc) == "undefined") {
						
					return this.config.arcSettings.translateTable["defaultARC"]
				}
				
				return false;
			}
		},
		
		getUserAgentInfo: function() {
			var userAgent = navigator.userAgent;
			var info = {
				OS: function() {
					if (/NT 6/i.test(userAgent)) {
						return 'Vista';
					}
					if (/NT 5\.1/i.test(userAgent)) {
						return 'XP';
					}
					if (/NT 5\.0/i.test(userAgent)) {
						return 'Win2k';
					}
					if (/MAC/i.test(userAgent)) {
						return 'Mac';
					}
					return 'other';
				}(),
				
				Browser: function() {
					if (/Firefox/i.test(userAgent)) {
						return 'Firefox';
					}
					if (/MSIE 7/i.test(userAgent)) {
						return 'IE 7';
					}
					if (/MSIE 6/i.test(userAgent)) {
						return 'IE 6';
					}
					if (/Chrome/i.test(userAgent)) {
						return 'Chrome';
					}
					if (/Safari/i.test(userAgent)) {
						return 'Safari';
					}
					if (/Opera/i.test(userAgent)) {
						return 'Opera';
					}
					return 'other';	
				}()
			};
			return info;
		},
		
		logExposure: function() {
			var info = this.getUserAgentInfo();
			var info = this.getUserAgentInfo();
			/*
			 * must follow this pattern: m/exp(?:_test)?\.pli\?pid=(p\d+)&prad=(.+)&arc=(.+)&grp=(\d)(?:&b=(.+)&os=([^&]+))?/i
			 */
			if (this.arc != _ar.Broker.config.masterSettings.controlAdArc) {
				_utils.fireBeacon(this.executingPath + this.config.logSettings.exposureBeaconUrl + 
				                   "?pid=" + this.config.masterSettings.projectId +
								   "&prad=" + this.prad + 
								   "&arc=" + this.arc +
								   "&grp=1" +
								   "&b=" + info.Browser +
								   "&os=" + info.OS +
								   "&redirectUrl=" + encodeURIComponent(this.config.logSettings.panelistLogUrl), true);
			}
			else {
				_utils.fireBeacon(this.config.logSettings.panelistLogUrl + 
				                   "?pid=" + this.config.masterSettings.projectId +
								   "&prad=" + this.prad + 
								   "&arc=" + this.arc +
								   "&grp=0" +
								   "&b=" + info.Browser +
								   "&os=" + info.OS
								   ,true);
			}
			
			//new! log prad and arc lists to new cookie
			if (this.config.logSettings.captureExposureList) {
				_utils.fireBeacon(this.executingPath + this.config.logSettings.exposureListLogUrl +
								  "?pid=" + this.config.masterSettings.projectId +
								  "&prad=" + this.prad + 
							      "&arc=" + this.arc, true);
			}
		}
	};
})();

//Keep Alive Domain Departure
COMSCORE.AdRecruit.DDKeepAlive = ( function() {
	// private methods and properties
	var _interval = 1000, _pageId = Math.random(), _timeoutId;

	// shorthand
	var _ar = COMSCORE.AdRecruit;
	var _utils = _ar.Utils;
	var _iframeId = "_arKeepAliveFrame";
	
	return {
		start: function() {
			var that = this;
			
			
			this.setDDTrackerCookie();	
		},
		
		stop: function() {
			var iframe = document.getElementById(_iframeId);
			if (iframe != null) {
				document.body.removeChild(iframe);
			}
			
		},
		
		setDDTrackerCookie: function() {
			var iframe = document.createElement("iframe");
			iframe.id = _iframeId;
			iframe.src = _ar.Broker.executingPath + _ar.Broker.config.ddSettings.keepAliveUrl + "?cookieName=" + 
						 _ar.Broker.config.cookieSettings.alreadyAskedCookieName + "&cookieValue=" +
						 _ar.Broker.config.ddSettings.cookieValue + "&location=" +
						 encodeURIComponent(_utils.location);
			iframe.height = 0;
			iframe.style.display = 'none';
			
			
			
			document.body.appendChild(iframe);
			
			
		}
	};
} )();

COMSCORE.AdRecruit.OnReady = ( function() {
		// for short hand
		var _ar = COMSCORE.AdRecruit;
		var _utils = _ar.Utils;
		
		// public methods and properties
		return {
			onload : function() {
				if (_ar.OnReady.done) { return; }
				_ar.OnReady.done = true;
				//_ar.Broker.start(); //initialize the broker once the DOM is ready
				//clean up
				//safari
				if(_ar.OnReady.timer){
					
					clearInterval(_ar.OnReady.timer);
				}
				//mozilla opera
				 if(document.addEventListener) {
					 
					document.removeEventListener("DOMContentLoaded", _ar.OnReady.onload, false);
				}
				//ie
				 if(window.ActiveXObject){
					 
					var defer = document.getElementById("ar__ie_onload");
					if(defer){
						defer.onreadystatechange = null;
						defer.parentNode.removeChild(defer);
					}
				}
			},
			listen : function() {
				//safari
				if (/WebKit|khtml/i.test(navigator.userAgent)) {
					_ar.OnReady.timer = setInterval(function() {
						if (/loaded|complete/.test(document.readyState)) {
							clearInterval(_ar.OnReady.timer);
							delete _ar.OnReady.timer;
							_ar.OnReady.onload();
						}}, 10);
				}
				//mozilla opera 
				else if (document.addEventListener) {
					document.addEventListener('DOMContentLoaded', _ar.OnReady.onload, false);
				}
				//ie
				else if (window.ActiveXObject) {
					_ar.OnReady.iew32 = true;
					
					//document.write('<script id="ar__ie_onload" defer="defer" src="' + ((location.protocol == 'https:') ? '//0' : 'javascript:void(0)') + '"><\/script>');
					//document.getElementById('ar__ie_onload').onreadystatechange = function(){
					//	if (this.readyState == 'complete') 
					//	{ 
							COMSCORE.AdRecruit.OnReady.waitForLoad = setInterval(function() {
				                try {
				                    // throws errors until after ondocummentready
				                    document.documentElement.doScroll('left');
								} catch (ex) {
									return;
				                }
				                COMSCORE.AdRecruit.OnReady.waitForLoad = clearInterval(COMSCORE.AdRecruit.OnReady.waitForLoad);
								COMSCORE.AdRecruit.OnReady.onload();
				            }, 1000);
							 
						//}};
				}
				//default ??
				else  {
					if(window.addEventListener) {
						window.addEventListener('load', _ar.OnReady.onload, false);
					} else if (window.attachEvent) {
						return window.attachEvent('onload', _ar.OnReady.onload);
					}
				}
			},
			f:[],done:false,timer:null
		};
	})();
	
	

COMSCORE.AdRecruit.Broker.config = {
	masterSettings: {projectId:"p28053044",excludeUrl:"mayoclinic.com|webmd.com|wired.com",includeUrl:"",excludePrad:"30088937|30088939|30088940|30088944|30088946|30088951|30088964|29792685|29792705|29792708|29792710|30476016",surveyUrl:"http://survey2.voicefive.com/wix/p28053044.aspx",arcName:"ar_c",pradName:"prad",controlAdArc:1},
	cookieSettings: {useHostedCookie:true,exposureCookieDomain:".voicefive.com",exposureCookieDuration:90,alreadyAskedCookieDuration:90,alreadyAskedCookieDomain:"",hostedCookieReadUrl:"../b/rc.pli",hostedCookieWriteUrl:"../b/wc.pli",globalCookieName:"AR_X"},
	logSettings: {viewParams:"log=/comScore/view/p28053044_AR-view.log",viewUrl:"http://web.survey-poll.com/tc/CreateLog.aspx",popupBlockedCreateLogParams:"?log=comScore/view/p28053044_AR-blocked.log",logPopupBlocked:false,exposureBeaconUrl:"../b/exp_test.pli",panelistLogUrl:"http://ar.voicefive.com/b/ping.gif",captureExposureList:true,exposureListLogUrl:"../b/pradarc_log.pli"},
	pradSettings: {defaultPrad:{recruitFrequency:0.1,methodology:1,isWPopAllowed:true,inv:"inv_300x250",acceptUrl:"./invite/invite.htm",acceptParamsRaw:"&dom=2",acceptWindowFeatures:"width=400,height=400,location=0,menubar=0,resizable=1,scrollbars=1,toolbar=0",delay:2000},arr:[{prad:[28277825,28277974,28278048,28331884,28332386,28461567,28461568,28461571,28647731,28647787,29792331,29792336,29792351,29792354,29792357,29792381,29792417,29792420,29792422,29792434,29792437,29792440,29792453,29792454,29792456,29792482,29792487,29792488,29792491,29792495,29792504,29792505,29792648,29792652,29792654,29792655,29792656,29792658,29792660,29792366,17444508,17488640,17488668,17488677,17488714,17488767,17488776,17601817,17993418,17994821,18007693,18010477,18010744,18013750,18045495,18561918,19146873,21021216,21023402,21023592,21033114,21038744,21138101,27956488,29779112],recruitFrequency:0.1,methodology:4,isWPopAllowed:false,inv:"inv_300x250",acceptUrl:"./invite/invite.htm",acceptParamsRaw:"",acceptWindowFeatures:"width=750,height=660,location=0,menubar=0,resizable=1,scrollbars=1,toolbar=0",delay:2000},{prad:[29792136,29792137,29792138,29792143,29792144,29792145,29792155,29792156,29792157,29792521,29792527,29792528,29792529,29792538,29792540,29792542,29792544,29792552,29792595,29792596,29792597,29792604,29792605,29792608,29792609,29792610,29792616,29792618,29792627,29792629,29792630,29792632,29792633,29792635,29792637,29792638,29792640,29792641,30088957,30088962,30088942],recruitFrequency:0.1,methodology:1,isWPopAllowed:false,inv:"inv_300x250",acceptUrl:"./invite/invite.htm",acceptParamsRaw:"",acceptWindowFeatures:"width=750,height=660,location=0,menubar=0,resizable=1,scrollbars=1,toolbar=0",delay:2000},{prad:[21020517,29792570],recruitFrequency:0.25,methodology:1,isWPopAllowed:true,inv:"inv_300x250",acceptUrl:"./invite/invite.htm",acceptParamsRaw:"",acceptWindowFeatures:"width=750,height=660,location=0,menubar=0,resizable=1,scrollbars=1,toolbar=0",delay:30000}]},
	inviteSettings: {yahoo:{content:"<table style='border:0;cellpadding:0;border-collapse:collapse;width:300px;height:150px;background-image:URL(yB.jpg);'><tr><td><div style='position:absolute;top:0;left:239px;'><a href='Close' onclick='__declineHandler__'><img src='c.jpg' style='cursor:pointer;border:0' /></a></div><div style='position:absolute;top:100px;left:0px;width:300px;'><center><input type='button' onclick='__acceptHandler__' value='Take the survey' />&nbsp;&nbsp;<input type='button' onclick='__declineHandler__' value='No, thanks' /></center></div></td></tr></table>",height:154,width:303,horizontalAlignment:2,verticalAlignment:2,horizontalMargin:0,verticalMargin:0,isHideBlockingElements:true,isAutoCentering:false},inv_300x250:{content:"<table style='border:0;cellpadding:0;border-collapse:collapse;width:300px;height:250px;background-image:URL(300x250_bg.jpg);opacity:0.95;'><tr><td><div style='position:absolute;top:5px;left:260px;'><img src='300x250_cl.gif' onClick='__declineHandler__' style='cursor:pointer;border:0' /></div><div style='position:absolute;top:140px;left:100px;'><img src='300x250_y.gif' onclick='__acceptHandler__' style='cursor:pointer;border:0' /></div><div style='position:absolute;top:218px;left:15px;'><a href='http://www.voicefive.com/priv.aspx' style='text-decoration:none;color:white;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold' target='_blank'>Privacy policy</a></div></td></tr></table>",height:250,width:300,horizontalAlignment:2,verticalAlignment:2,horizontalMargin:0,verticalMargin:0,isHideBlockingElements:false,isAutoCentering:false},inv_728x90:{content:"<table style='border:0;cellpadding:0;border-collapse:collapse;width:728px;height:90px;background-image:URL(728x90_bg.jpg);opacity:0.95;'><tr><td><div style='position:absolute;top:5px;left:690px;'><img src='728x90_cl.gif' onClick='__declineHandler__' style='cursor:pointer;border:0' /></div><div style='position:absolute;top:35px;left:200px;'><img src='728x90_y.gif' onclick='__acceptHandler__' style='cursor:pointer;border:0' /></div><div style='position:absolute;top:52px;left:18px;'><a href='http://www.voicefive.com/priv.aspx' style='text-decoration:none;color:white;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold' target='_blank'>Privacy policy</a></div></td></tr></table>",height:90,width:728,horizontalAlignment:0,verticalAlignment:0,horizontalMargin:0,verticalMargin:0,isHideBlockingElements:true,isAutoCentering:false},inv_160x600:{content:"<table style='border:0;cellpadding:0;border-collapse:collapse;width:160px;height:600px;background-image:URL(160x600_bg.jpg);opacity:0.95;'><tr><td><div style='position:absolute;top:5px;left:115px;'><img src='160x600_cl.gif' onClick='__declineHandler__' style='cursor:pointer;border:0' /></div><div style='position:absolute;top:380px;left:30px;'><img src='160x600_y.gif' onclick='__acceptHandler__' style='cursor:pointer;border:0' /></div><div style='position:absolute;top:500px;left:38px;'><a href='http://www.voicefive.com/priv.aspx' style='text-decoration:none;color:white;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;font-weight:bold' target='_blank'>Privacy policy</a></div></td></tr></table>",height:600,width:160,horizontalAlignment:0,verticalAlignment:0,horizontalMargin:0,verticalMargin:0,isHideBlockingElements:true,isAutoCentering:false}},
	arcSettings: {arr:[{arc:[1],recruitFrequency:0}],trackCreative:true,translateTable:{defaultARC:500,1:501,26043577:502,28277825:503,28277959:504,28277974:505,28278024:506,28278048:507,28279979:508,28321337:509,28331884:510,28332164:511,28332386:512,28429392:513,28461567:514,28461568:515,28461571:516,28647731:517,28647787:518,28648450:519,28684250:520}},
	ddSettings: {keepAliveUrl:"../b/KeepAlive.htm",trackerPageUrl:"AdRecruit_Tracker.htm",cookieValue:"2",trackerWindow:{width:420,height:360,orientation:1,offsetX:0,offsetY:0,features:"scrollbars=1,resizable=1"}}
};

COMSCORE.AdRecruit.Broker.config.cookieSettings.alreadyAskedCookieName = "ar_s_" + 
	COMSCORE.AdRecruit.Broker.config.masterSettings.projectId;
COMSCORE.AdRecruit.Broker.config.cookieSettings.interactionCookieName = "ar_int_" + 
	COMSCORE.AdRecruit.Broker.config.masterSettings.projectId;
COMSCORE.AdRecruit.Broker.config.cookieSettings.exposureCookieName = "ar_" +
	COMSCORE.AdRecruit.Broker.config.masterSettings.projectId;
	
COMSCORE.AdRecruit.Broker.globalConfig = {
	urlExcludeList: "digg.com|facebook.com|get.live.com|cnbc.com|officelive.com|office.microsoft.com|mail.live.com"
};
//COMSCORE.AdRecruit.OnReady.listen();
COMSCORE.AdRecruit.Broker.start();	
} // multiple script protection